<?php

use Dingo\Api\Routing\Router;

/** @var Router $api */
$api = app(Router::class);

$api->version('v1', function (Router $api) {
    $api->group(['prefix' => 'auth'], function(Router $api) {
        $api->post('signup', 'App\\Api\\V1\\Controllers\\SignUpController@signUp');
        $api->post('login', 'App\\Api\\V1\\Controllers\\LoginController@login');

        $api->post('recovery', 'App\\Api\\V1\\Controllers\\ForgotPasswordController@sendResetEmail');
        $api->post('reset', 'App\\Api\\V1\\Controllers\\ResetPasswordController@resetPassword');

        $api->post('logout', 'App\\Api\\V1\\Controllers\\LogoutController@logout');
        $api->post('refresh', 'App\\Api\\V1\\Controllers\\RefreshController@refresh');
        $api->get('me', 'App\\Api\\V1\\Controllers\\UserController@me');
    });

    $api->group(['prefix' => 'admin/auth'], function(Router $api) {
        $api->post('login', 'App\\Api\\V1\\Controllers\\AdminController@login');

    });

    $api->group(['middleware' => 'jwt.auth'], function(Router $api) {
        $api->get('protected', function() {
            return response()->json([
                'message' => 'Access to protected resources granted! You are seeing this text as you provided the token correctly.'
            ]);
        });

        $api->group(['prefix' => 'driver'], function(Router $api) {
            $api->get('search', 'App\\Api\\V1\\Controllers\\DriverController@searchBuses');
            $api->get('kids/{id}', 'App\\Api\\V1\\Controllers\\DriverController@getDriverKids');
            $api->put('kid/add', 'App\\Api\\V1\\Controllers\\DriverController@addKidsToDriver');
            $api->put('kid/accept', 'App\\Api\\V1\\Controllers\\DriverController@acceptKid');
            $api->get('{id}', 'App\\Api\\V1\\Controllers\\DriverController@show');
            $api->put('{id}', 'App\\Api\\V1\\Controllers\\DriverController@update');
            $api->put('reset/{id}', 'App\\Api\\V1\\Controllers\\UserController@update_password');
        });

        $api->group(['prefix' => 'token'], function(Router $api) {
            $api->post('update', 'App\\Api\\V1\\Controllers\\UserController@update_onesignal');
            $api->post('delete', 'App\\Api\\V1\\Controllers\\UserController@delete_onesignal');
        });

        $api->group(['prefix' => 'user'], function(Router $api) {
            $api->put('avatar', 'App\\Api\\V1\\Controllers\\UserController@uploadAvatar');
            $api->put('{id}', 'App\\Api\\V1\\Controllers\\UserController@update');
            $api->get('parent/{id}', 'App\\Api\\V1\\Controllers\\UserController@showParent');
            $api->get('kids/{id}', 'App\\Api\\V1\\Controllers\\UserController@getParentKids');
            $api->get('getAvatar/{id}', 'App\\Api\\V1\\Controllers\\UserController@getAvatar');
        });

        $api->group(['prefix' => 'school'], function(Router $api) {
            $api->get('all', 'App\\Api\\V1\\Controllers\\SchoolController@index');
            $api->get('search', 'App\\Api\\V1\\Controllers\\SchoolController@searchSchools');
            $api->get('{id}', 'App\\Api\\V1\\Controllers\\SchoolController@show');
            $api->put('location', 'App\\Api\\V1\\Controllers\\SchoolController@updateLocation');
        });

        $api->group(['prefix' => 'kid'], function(Router $api) {
            $api->post('new', 'App\\Api\\V1\\Controllers\\KidController@create');
            $api->get('assign/{id}', 'App\\Api\\V1\\Controllers\\KidController@kidsForAssign');
            $api->get('accept/{id}', 'App\\Api\\V1\\Controllers\\KidController@kidsToAccept');
            $api->get('check/{id}', 'App\\Api\\V1\\Controllers\\KidController@checkKidStatus');
            $api->put('remove', 'App\\Api\\V1\\Controllers\\KidController@removeFromList');
            $api->put('{id}', 'App\\Api\\V1\\Controllers\\KidController@update');
            $api->delete('{id}', 'App\\Api\\V1\\Controllers\\KidController@delete');
            $api->get('{id}', 'App\\Api\\V1\\Controllers\\KidController@show');
        });

        $api->group(['prefix' => 'location'], function(Router $api) {
            $api->get('', 'App\\Api\\V1\\Controllers\\LocationController@index');
        });

        $api->group(['prefix' => 'dialogue'], function(Router $api) {
            $api->get('getDialogueDriver', 'App\\Api\\V1\\Controllers\\DialogueController@getDialogueDriver');
            $api->get('getDialogueRepresentative', 'App\\Api\\V1\\Controllers\\DialogueController@getDialogueRepresentative');
        });

        $api->group(['prefix' => 'route_log'], function(Router $api) {
            $api->post('', 'App\\Api\\V1\\Controllers\\RouteLogController@getLog');
            $api->post('follow', 'App\\Api\\V1\\Controllers\\RouteLogController@getLastGps');
            $api->post('new', 'App\\Api\\V1\\Controllers\\RouteLogController@createLog');
            $api->put('end/{id}/{tipo_fin_ruta}', 'App\\Api\\V1\\Controllers\\RouteLogController@endLog');
            $api->get('getRouteLogByIdAndKidById/{idRouteLog}/{idKid}', 'App\\Api\\V1\\Controllers\\RouteLogController@getRouteLogByIdAndKidById');
            $api->get('getRouteByRouteLogId/{kidId}', 'App\\Api\\V1\\Controllers\\RouteLogController@getRouteByRouteLogId');
            $api->get('getLastRouteLogGpsByIdRouteLog/{id}', 'App\\Api\\V1\\Controllers\\RouteLogController@getLastRouteLogGpsByIdRouteLog');
            $api->get('getLastRouteLogKidByIdRouteLog/{idKid}/{idRouteLog}', 'App\\Api\\V1\\Controllers\\RouteLogController@getLastRouteLogKidByIdRouteLog');
            $api->post('gps', 'App\\Api\\V1\\Controllers\\RouteLogController@updateLocation');
            $api->post('gpsStatusKid', 'App\\Api\\V1\\Controllers\\RouteLogController@updateLocationSetStatusKid');
            $api->put('notgetin/{id}', 'App\\Api\\V1\\Controllers\\RouteLogController@notGetInBus');
            $api->put('getoff/massive', 'App\\Api\\V1\\Controllers\\RouteLogController@getOffBusMassive');
            $api->put('geton/massive', 'App\\Api\\V1\\Controllers\\RouteLogController@getOnBusMassive');
            $api->put('getoff/{id}', 'App\\Api\\V1\\Controllers\\RouteLogController@getOffBus');
            $api->put('geton/{id}', 'App\\Api\\V1\\Controllers\\RouteLogController@getOnBus');
            $api->get('verifyLastStatusRoute/{id}', 'App\\Api\\V1\\Controllers\\RouteLogController@verifyLastStatusRoute');
        });

        $api->group(['prefix' => 'route'], function(Router $api) {
            $api->get('', 'App\\Api\\V1\\Controllers\\RouteController@index');
            $api->get('{id}', 'App\\Api\\V1\\Controllers\\RouteController@show');
            $api->post('', 'App\\Api\\V1\\Controllers\\RouteController@create');
            $api->put('', 'App\\Api\\V1\\Controllers\\RouteController@update');
            $api->delete('{id}', 'App\\Api\\V1\\Controllers\\RouteController@delete');
        });

        $api->group(['prefix' => 'payment'], function(Router $api) {
            $api->get('{id}', 'App\\Api\\V1\\Controllers\\PaymentController@show');
            $api->get('payer/{id}', 'App\\Api\\V1\\Controllers\\PaymentController@payer');
            $api->get('receiver/{id}', 'App\\Api\\V1\\Controllers\\PaymentController@receiver');
        });

        $api->group(['prefix' => 'notification'], function(Router $api) {
            $api->get('{id}', 'App\\Api\\V1\\Controllers\\NotificationController@index');
            $api->post('todriver/{id}', 'App\\Api\\V1\\Controllers\\NotificationController@messageToDriver');
            $api->post('toparents/{id}', 'App\\Api\\V1\\Controllers\\NotificationController@messageToParents');
            $api->delete('{id}', 'App\\Api\\V1\\Controllers\\NotificationController@delete');
        });@

        $api->group(['prefix' => 'admin'], function(Router $api) {

            $api->get('college', 'App\\Api\\V1\\Controllers\\AdminController@college_index');
            $api->get('college/{id}', 'App\\Api\\V1\\Controllers\\AdminController@college_show');
            $api->get('college/user/{id}', 'App\\Api\\V1\\Controllers\\AdminController@college_show_user');
            $api->post('college', 'App\\Api\\V1\\Controllers\\AdminController@college_new');
            $api->put('college/{id}', 'App\\Api\\V1\\Controllers\\AdminController@college_edit');
            $api->get('college/getAvatarCollege/{id}', 'App\\Api\\V1\\Controllers\\AdminController@getAvatarCollege');
 

            $api->get('kids/detail/{id}', 'App\\Api\\V1\\Controllers\\AdminController@showKid');
            $api->put('kids/{id}', 'App\\Api\\V1\\Controllers\\AdminController@kids_edit');

            $api->get('users/{id}', 'App\\Api\\V1\\Controllers\\AdminController@users_index');
            $api->get('users/detail/{id}', 'App\\Api\\V1\\Controllers\\AdminController@users_show');
            $api->put('users/{id}', 'App\\Api\\V1\\Controllers\\AdminController@users_edit');
            $api->get('users/getAvatar/{id}', 'App\\Api\\V1\\Controllers\\AdminController@getAvatar');

            $api->post('driver/documents/getDocument', 'App\\Api\\V1\\Controllers\\AdminController@getDocumentDownload');
            $api->get('driver/documents/{id}', 'App\\Api\\V1\\Controllers\\AdminController@driver_documents');
            $api->post('driver/documents', 'App\\Api\\V1\\Controllers\\AdminController@driver_documents_upload');
            $api->post('driver/documents/phone', 'App\\Api\\V1\\Controllers\\AdminController@driver_documents_upload_phone');


            $api->get('routes', 'App\\Api\\V1\\Controllers\\AdminController@routes_index');
            $api->get('routes/detail/{id}', 'App\\Api\\V1\\Controllers\\AdminController@routes_show');
            $api->get('routes/history/{id}', 'App\\Api\\V1\\Controllers\\AdminController@route_history');
            $api->get('routes/history/detail/{id}', 'App\\Api\\V1\\Controllers\\AdminController@route_history_show');

            $api->get('files/pending', 'App\\Api\\V1\\Controllers\\AdminController@pending_documents');
            $api->get('files/approved', 'App\\Api\\V1\\Controllers\\AdminController@approved_documents');
            $api->put('files/approve/{id}', 'App\\Api\\V1\\Controllers\\AdminController@approve_document');
            $api->put('files/reject/{id}', 'App\\Api\\V1\\Controllers\\AdminController@reject_document');
            $api->put('files/delete/logo/{id}', 'App\\Api\\V1\\Controllers\\AdminController@remove_college_logo');
            $api->put('files/delete/avatar/{id}', 'App\\Api\\V1\\Controllers\\AdminController@remove_user_avatar');

            $api->get('stats', 'App\\Api\\V1\\Controllers\\AdminController@admin_stats');
        });

        $api->get('refresh', [
            'middleware' => 'jwt.refresh',
            function() {
                return response()->json([
                    'message' => 'By accessing this endpoint, you can refresh your access token at each request. Check out this response headers!'
                ]);
            }
        ]);
    });

    $api->get('hello', function() {
        return response()->json([
            'message' => 'This is a simple example of item returned by your APIs. Everyone can see it.'
        ]);
    });
    $api->get('test', 'App\\Api\\V1\\Controllers\\TestController@test');
});