<?php

namespace App\Traits;

use OneSignal;
use Symfony\Component\HttpKernel\Exception\HttpException;
use App\Models\Notification;
use Illuminate\Support\Facades\Log;

trait OneSignalMessages
{
    public function sendNotificationKidToDriver($driver, $kid)
    {
        // Get all the brands from the Brands Table.
        error_log('1');
        //$parameters['app_id'] = getenv('ONE_SIGNAL_APP_ID');//'eaa343df-5685-45d1-a58f-f8696cbb7770';
        $parameters['include_external_user_ids'] = [$driver['user_id']];


        //$parameters['content_available'] = 1;

        $parameters['headings'] = ['en' => $driver->first_name . ', ¡Tiene una nueva asignación!'];
        //$parameters['collapse_id'] = 'findPostulants';
        //$parameters['ios_badgeType'] = 'Increase';
        //$parameters['ios_badgeCount'] = 1;

        $parameters['contents'] = ['en' => 'Se ha asignado a: ' . $kid->first_name . ' ' . $kid->last_name . '.'];
        //$parameters['data'] = ['type'=>'_open_offers_details', 'id'=>$id];
        $newNotification = new Notification([
            'title' => $parameters['headings']['en'],
            'message' => $parameters['contents']['en'],
            'icon' => '',
            'user_id' => $driver['user_id'],
        ]);

        if (!$newNotification->save()) {
            throw new HttpException(500);
        }

        //$parameters['large_icon'] = 'https://www.lookbook.cl/wp-content/uploads/2019/12/logoAlt@2x-80x80.png';

        $response = OneSignal::sendNotificationCustom($parameters);
        $body = $response->getBody();
        // Implicitly cast the body to a string and echo it
        //echo $body;
    }

    public function sendNotificationFromParentToDriver($message, $kid, $driver, $sender)
    {
        error_log("2");
        // Get all the brands from the Brands Table.
        //$parameters['app_id'] = getenv('ONE_SIGNAL_APP_ID'); //'eaa343df-5685-45d1-a58f-f8696cbb7770';
        $parameters['include_external_user_ids'] = [$driver['user_id']];
        //$parameters['content_available'] = 1;

        $parameters['headings'] = ['en' => $sender->first_name . ', apoderado de ' . $kid['first_name'] . ' ha mandado un mensaje.'];
        //$parameters['collapse_id'] = 'findPostulants';
        //$parameters['ios_badgeType'] = 'Increase';
        //$parameters['ios_badgeCount'] = 1;

        $parameters['contents'] = ['en' => $message];
        //$parameters['data'] = ['type'=>'_open_offers_details', 'id'=>$id];
        $newNotification = new Notification([
            'title' => $parameters['headings']['en'],
            'message' => $parameters['contents']['en'],
            'icon' => '',
            'user_id' => $driver['user_id'],
        ]);

        if (!$newNotification->save()) {
            throw new HttpException(500);
        }

        $response = OneSignal::sendNotificationCustom($parameters);
        $body = $response->getBody();
        // Implicitly cast the body to a string and echo it
        //echo $body;
    }

    public function sendNotificationFromDriverToParents($message, $kid, $parents, $sender)
    {
        error_log("3");
        // Get all the brands from the Brands Table.
        //$parameters['app_id'] = getenv('ONE_SIGNAL_APP_ID');//'eaa343df-5685-45d1-a58f-f8696cbb7770';
        $parameters['include_external_user_ids'] = [$parents];
        //$parameters['content_available'] = 1;

        $parameters['headings'] = ['en' => $sender->first_name . ', chofer de ' . $kid->first_name . ' ha mandado un mensaje.'];
        //$parameters['collapse_id'] = 'findPostulants';
        //$parameters['ios_badgeType'] = 'Increase';
        //$parameters['ios_badgeCount'] = 1;

        $parameters['contents'] = ['en' => $message];
        //$parameters['data'] = ['type'=>'_open_offers_details', 'id'=>$id];
        foreach ($parents as $parent) {
            $newNotification = new Notification([
                'title' => $parameters['headings']['en'],
                'message' => $parameters['contents']['en'],
                'icon' => '',
                'user_id' => $parent,
            ]);

            if (!$newNotification->save()) {
                throw new HttpException(500);
            }
        }

        $response = OneSignal::sendNotificationCustom($parameters);
        $body = $response->getBody();
        // Implicitly cast the body to a string and echo it
        //echo $body;
    }

    public function sendNotificationDriverToParentsAcceptKid($driver, $kid, $parents)
    {
        error_log("14");
        // Get all the brands from the Brands Table.
        // $parameters['app_id'] = getenv('ONE_SIGNAL_APP_ID');//'eaa343df-5685-45d1-a58f-f8696cbb7770';
        $parameters['include_external_user_ids'] = [$parents];
        //$parameters['content_available'] = 1;

        $parameters['headings'] = ['en' => $kid->first_name . ' ha sido aceptado por el conductor.'];
        //$parameters['collapse_id'] = 'findPostulants';
        //$parameters['ios_badgeType'] = 'Increase';
        //$parameters['ios_badgeCount'] = 1;

        $parameters['contents'] = ['en' => $driver->first_name . ' ' . $driver->last_name . ' aceptó a su hijo/a en su furgón.'];
        //$parameters['data'] = ['type'=>'_open_offers_details', 'id'=>$id];
        foreach ($parents as $parent) {
            $newNotification = new Notification([
                'title' => $parameters['headings']['en'],
                'message' => $parameters['contents']['en'],
                'icon' => '',
                'user_id' => $parent,
            ]);

            if (!$newNotification->save()) {
                throw new HttpException(500);
            }
        }

        //$parameters['large_icon'] = 'https://www.lookbook.cl/wp-content/uploads/2019/12/logoAlt@2x-80x80.png';

        $response = OneSignal::sendNotificationCustom($parameters);
        $body = $response->getBody();
        // Implicitly cast the body to a string and echo it
        //echo $body;
    }

    public function sendNotificationKidToUserOnBus($routeName, $driverName, $kid, $parents)
    {
        error_log("15");
        // Get all the brands from the Brands Table.
        //$parameters['app_id'] = getenv('ONE_SIGNAL_APP_ID');//'eaa343df-5685-45d1-a58f-f8696cbb7770';
        $parameters['include_external_user_ids'] = $parents;
        //$parameters['content_available'] = 1;

        $parameters['headings'] = ['en' => $kid->first_name . ' ha subido al furgón.'];
        //$parameters['collapse_id'] = 'findPostulants';
        //$parameters['ios_badgeType'] = 'Increase';
        //$parameters['ios_badgeCount'] = 1;

        $parameters['contents'] = [
            'en' =>
            'El conductor ' . $driverName . ' recogió a su hijo a las ' . date('H:i') . ' de su domicilio.'
        ];
        //$parameters['data'] = ['type'=>'_open_offers_details', 'id'=>$id];
        foreach ($parents as $parent) {
            $newNotification = new Notification([
                'title' => $parameters['headings']['en'],
                'message' => $parameters['contents']['en'],
                'icon' => '',
                'user_id' => $parent,
            ]);

            if (!$newNotification->save()) {
                throw new HttpException(500);
            }
        }

        //$parameters['large_icon'] = 'https://www.lookbook.cl/wp-content/uploads/2019/12/logoAlt@2x-80x80.png';

        $response = OneSignal::sendNotificationCustom($parameters);
        $body = $response->getBody();
        // Implicitly cast the body to a string and echo it
        //echo $body;
    }


    public function sendNotificationFinishRouteParents($driverName, $parents)
    {
        error_log("211");
        // Get all the brands from the Brands Table.
        //$parameters['app_id'] = getenv('ONE_SIGNAL_APP_ID');//'eaa343df-5685-45d1-a58f-f8696cbb7770';
        $parameters['include_external_user_ids'] = $parents;
        //$parameters['content_available'] = 1;

        $parameters['headings'] = ['en' => '¡Finalizado!'];
        //$parameters['collapse_id'] = 'findPostulants';
        //$parameters['ios_badgeType'] = 'Increase';
        //$parameters['ios_badgeCount'] = 1;

        $parameters['contents'] = [
            'en' =>
            //'El conductor '.$driverName.' dejó a su hijo a las '.date('H:i').' en su domicilio.'
            'La ruta ha concluido.' //  'Llegará pronto.'
        ];
        //$parameters['data'] = ['type'=>'_open_offers_details', 'id'=>$id];
        foreach ($parents as $parent) {
            $newNotification = new Notification([
                'title' => $parameters['headings']['en'],
                'message' => $parameters['contents']['en'],
                'icon' => '',
                'user_id' => $parent,
            ]);

            if (!$newNotification->save()) {
                throw new HttpException(500);
            }
        }

        //$parameters['large_icon'] = 'https://www.lookbook.cl/wp-content/uploads/2019/12/logoAlt@2x-80x80.png';
        Log::info($parameters);
        $response = OneSignal::sendNotificationCustom($parameters);
        $body = $response->getBody();
        // Implicitly cast the body to a string and echo it
        //echo $body;
    }



    // avisara a los padres de los niños que estan inicialmente listos para la ruta
    // los inasistentes se manejaran con una nueva tabla kid_route_active
    public function sendNotificationInitRouteParents($driverName, $parents)
    {
        error_log("20");
        // Get all the brands from the Brands Table.
        //$parameters['app_id'] = getenv('ONE_SIGNAL_APP_ID');//'eaa343df-5685-45d1-a58f-f8696cbb7770';
        $parameters['include_external_user_ids'] = $parents;
        //$parameters['content_available'] = 1;

        $parameters['headings'] = ['en' => 'El chofer, ' . $driverName . ' ha iniciado la ruta.'];
        //$parameters['collapse_id'] = 'findPostulants';
        //$parameters['ios_badgeType'] = 'Increase';
        //$parameters['ios_badgeCount'] = 1;

        $parameters['contents'] = [
            'en' =>
            //'El conductor '.$driverName.' dejó a su hijo a las '.date('H:i').' en su domicilio.'
            'Llegará pronto.'
        ];
        //$parameters['data'] = ['type'=>'_open_offers_details', 'id'=>$id];
        foreach ($parents as $parent) {
            $newNotification = new Notification([
                'title' => $parameters['headings']['en'],
                'message' => $parameters['contents']['en'],
                'icon' => '',
                'user_id' => $parent,
            ]);

            if (!$newNotification->save()) {
                throw new HttpException(500);
            }
        }

        //$parameters['large_icon'] = 'https://www.lookbook.cl/wp-content/uploads/2019/12/logoAlt@2x-80x80.png';
        Log::info($parameters);
        $response = OneSignal::sendNotificationCustom($parameters);
        $body = $response->getBody();
        // Implicitly cast the body to a string and echo it
        //echo $body;
    }



    public function sendNotificationKidToUserOffBus($routeName, $driverName, $kid, $parents)
    {
        error_log("16");
        // Get all the brands from the Brands Table.
        //$parameters['app_id'] = getenv('ONE_SIGNAL_APP_ID');//'eaa343df-5685-45d1-a58f-f8696cbb7770';
        $parameters['include_external_user_ids'] = $parents;
        //$parameters['content_available'] = 1;

        $parameters['headings'] = ['en' => $kid->first_name . ' ha bajado del furgón.'];
        //$parameters['collapse_id'] = 'findPostulants';
        //$parameters['ios_badgeType'] = 'Increase';
        //$parameters['ios_badgeCount'] = 1;

        $parameters['contents'] = [
            'en' =>
            'El conductor ' . $driverName . ' dejó a su hijo a las ' . date('H:i') . ' en su domicilio.'
        ];
        //$parameters['data'] = ['type'=>'_open_offers_details', 'id'=>$id];
        foreach ($parents as $parent) {
            $newNotification = new Notification([
                'title' => $parameters['headings']['en'],
                'message' => $parameters['contents']['en'],
                'icon' => '',
                'user_id' => $parent,
            ]);

            if (!$newNotification->save()) {
                throw new HttpException(500);
            }
        }

        //$parameters['large_icon'] = 'https://www.lookbook.cl/wp-content/uploads/2019/12/logoAlt@2x-80x80.png';

        $response = OneSignal::sendNotificationCustom($parameters);
        $body = $response->getBody();
        // Implicitly cast the body to a string and echo it
        //echo $body;
    }


    public function sendNotificationKidToUserEndRoute($routeName, $driverName, $kid, $parents)
    {
        error_log("17");
        // Get all the brands from the Brands Table.
        //$parameters['app_id'] = getenv('ONE_SIGNAL_APP_ID');//'eaa343df-5685-45d1-a58f-f8696cbb7770';
        $parameters['include_external_user_ids'] = $parents;
        //$parameters['content_available'] = 1;

        $parameters['headings'] = ['en' => $kid->first_name . ' ha bajado del furgón.'];
        //$parameters['collapse_id'] = 'findPostulants';
        //$parameters['ios_badgeType'] = 'Increase';
        //$parameters['ios_badgeCount'] = 1;

        $parameters['contents'] = [
            'en' =>
            'El conductor ' . $driverName . ' dejó a su hijo a las ' . date('H:i') . ' en destino.'
        ];
        //$parameters['data'] = ['type'=>'_open_offers_details', 'id'=>$id];
        foreach ($parents as $parent) {
            $newNotification = new Notification([
                'title' => $parameters['headings']['en'],
                'message' => $parameters['contents']['en'],
                'icon' => '',
                'user_id' => $parent,
            ]);

            if (!$newNotification->save()) {
                throw new HttpException(500);
            }
        }

        //$parameters['large_icon'] = 'https://www.lookbook.cl/wp-content/uploads/2019/12/logoAlt@2x-80x80.png';

        $response = OneSignal::sendNotificationCustom($parameters);
        $body = $response->getBody();
        // Implicitly cast the body to a string and echo it
        //echo $body;
    }

    public function sendNotificationKidToUserStartRoute($routeName, $driverName, $kid, $parents)
    {
        error_log("18");
        // Get all the brands from the Brands Table.
        //$parameters['app_id'] = getenv('ONE_SIGNAL_APP_ID');//'eaa343df-5685-45d1-a58f-f8696cbb7770';
        $parameters['include_external_user_ids'] = $parents;
        //$parameters['content_available'] = 1;

        $parameters['headings'] = ['en' => $kid->first_name . ' ha subido al furgón.'];
        //$parameters['collapse_id'] = 'findPostulants';
        //$parameters['ios_badgeType'] = 'Increase';
        //$parameters['ios_badgeCount'] = 1;

        $parameters['contents'] = [
            'en' =>
            'El conductor ' . $driverName . ' recogió a su hijo a las ' . date('H:i') . ' de su establecimiento.'
        ];
        //$parameters['data'] = ['type'=>'_open_offers_details', 'id'=>$id];
        foreach ($parents as $parent) {
            $newNotification = new Notification([
                'title' => $parameters['headings']['en'],
                'message' => $parameters['contents']['en'],
                'icon' => '',
                'user_id' => $parent,
            ]);

            if (!$newNotification->save()) {
                throw new HttpException(500);
            }
        }

        //$parameters['large_icon'] = 'https://www.lookbook.cl/wp-content/uploads/2019/12/logoAlt@2x-80x80.png';

        $response = OneSignal::sendNotificationCustom($parameters);
        $body = $response->getBody();
        // Implicitly cast the body to a string and echo it
        //echo $body;
    }

    public function sendNotificationKidToUserNotGetInBus($kid, $parents)
    {
        error_log("19");
        // Get all the brands from the Brands Table.
        //$parameters['app_id'] = getenv('ONE_SIGNAL_APP_ID');//'eaa343df-5685-45d1-a58f-f8696cbb7770';
        $parameters['include_external_user_ids'] = [$parents];
        //$parameters['content_available'] = 1;

        $parameters['headings'] = ['en' => $kid->first_name . ' no fue recogido por el conductor.'];
        //$parameters['collapse_id'] = 'findPostulants';
        //$parameters['ios_badgeType'] = 'Increase';
        //$parameters['ios_badgeCount'] = 1;

        $parameters['contents'] = ['en' => $kid->first_name . ' no se subió al furgón.'];
        //$parameters['data'] = ['type'=>'_open_offers_details', 'id'=>$id];
        foreach ($parents as $parent) {
            $newNotification = new Notification([
                'title' => $parameters['headings']['en'],
                'message' => $parameters['contents']['en'],
                'icon' => '',
                'user_id' => $parent,
            ]);

            if (!$newNotification->save()) {
                throw new HttpException(500);
            }
        }

        //$parameters['large_icon'] = 'https://www.lookbook.cl/wp-content/uploads/2019/12/logoAlt@2x-80x80.png';

        $response = OneSignal::sendNotificationCustom($parameters);
        $body = $response->getBody();
        // Implicitly cast the body to a string and echo it
        //echo $body;
    }
}
