<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;

class NewUser extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    private $first_name;
    private $user;
    private $pass;
    
    public function __construct($first_name, $user, $pass)
    {
        //
        $this->first_name = $first_name;
        $this->user = $user;
        $this->pass = $pass;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
    
        return (new MailMessage)
            ->subject($this->first_name.', ¡Bienvenido!')
            ->replyTo(env('MAIL_REPLYTO'), 'Staff BeeSafe')
            ->markdown('emails.newuser', [
                'url' => env('FRONTEND_URL'), 
                'first_name'=>$this->first_name,
                'user'=>$this->user,
                'pass'=>$this->pass
            ]);
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
