<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;

/**
 * App\Models\School
 *
 * @property int $id
 * @property string $name
 * @property string $avatar
 * @property string $working_time
 * @property string $created_at
 * @property string $updated_at
 * @property string $district
 * @property Kid[] $kids
 * @property Driver[] $drivers
 * @property string $address
 * @property string|null $email
 * @property string|null $phone
 * @property float|null $lat
 * @property float|null $lng
 * @property int|null $user_id
 * @property string|null $first_arrival_time
 * @property string|null $first_closing_time
 * @property string|null $second_arrival_time
 * @property string|null $second_closing_time
 * @property-read int|null $drivers_count
 * @property-read mixed $avatar_url
 * @property-read int|null $kids_count
 * @property-read \App\Models\User|null $user
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\School newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\School newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\School query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\School whereAddress($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\School whereAvatar($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\School whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\School whereDistrict($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\School whereEmail($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\School whereFirstArrivalTime($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\School whereFirstClosingTime($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\School whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\School whereLat($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\School whereLng($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\School whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\School wherePhone($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\School whereSecondArrivalTime($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\School whereSecondClosingTime($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\School whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\School whereUserId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\School whereWorkingTime($value)
 * @mixin \Eloquent
 */
class School extends Model
{
    /**
     * The table associated with the model.
     * 
     * @var string
     */
    protected $table = 'school';

    /**
     * @var array
     */
    protected $fillable = ['id','name', 'avatar', 'working_time', 'created_at', 'updated_at', 'district',
    'address', 'email', 'phone', 'lat', 'lng', 'user_id', 'first_arrival_time', 'first_closing_time',
    'second_arrival_time', 'second_closing_time'];
    
    protected $appends = ['avatarUrl'];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function kids()
    {
        return $this->hasMany('App\Models\Kid');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function drivers()
    {
        return $this->belongsToMany('App\Models\Driver', 'school_driver');
    }
    
    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }
    
    public function getAvatarUrlAttribute()
    {
        return env('APP_URL').Storage::url('avatars/'.$this->avatar);
    }
}