<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * App\Models\RouteStop
 *
 * @property int $id
 * @property int $route_id
 * @property integer $order
 * @property float $lat
 * @property float $lng
 * @property int $kid_id
 * @property int $school_id
 * @property string $created_at
 * @property string $updated_at
 * @property Route $route
 * @property-read \App\Models\Kid|null $kid
 * @property-read \App\Models\School|null $school
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\RouteStop newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\RouteStop newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\RouteStop query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\RouteStop whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\RouteStop whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\RouteStop whereKidId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\RouteStop whereLat($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\RouteStop whereLng($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\RouteStop whereOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\RouteStop whereRouteId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\RouteStop whereSchoolId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\RouteStop whereUpdatedAt($value)
 * @mixin \Eloquent
 */
class RouteStop extends Model
{
    /**
     * The table associated with the model.
     * 
     * @var string
     */
    protected $table = 'route_stop';

    /**
     * @var array
     */
    protected $fillable = ['route_id', 'order', 'lat', 'lng', 'kid_id', 'school_id', 'created_at', 'updated_at'];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function route()
    {
        return $this->belongsTo('App\Models\Route');
    }
    
    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function kid()
    {
        return $this->belongsTo('App\Models\Kid');
    }
    
    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function school()
    {
        return $this->belongsTo('App\Models\School');
    }
}