<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * App\Models\RouteLogKid
 *
 * @property int $id
 * @property int $route_log_id
 * @property int $kid_id
 * @property int $status
 * @property string $created_at
 * @property string $updated_at
 * @property RouteLog $routeLog
 * @property-read \App\Models\Kid $kid
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\RouteLogKid newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\RouteLogKid newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\RouteLogKid query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\RouteLogKid whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\RouteLogKid whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\RouteLogKid whereKidId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\RouteLogKid whereRouteLogId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\RouteLogKid whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\RouteLogKid whereUpdatedAt($value)
 * @mixin \Eloquent
 */
class RouteLogKid extends Model
{
    /**
     * The table associated with the model.
     * 
     * @var string
     */
    protected $table = 'route_log_kid';

    /**
     * @var array
     */
    protected $fillable = ['route_log_id', 'kid_id', 'status', 'created_at', 'updated_at','lat','lng',
    'got_in_bus_time', 'got_off_bus_time'];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function routeLog()
    {
        return $this->belongsTo('App\Models\RouteLog');
    }
    
    public function kid()
    {
        return $this->belongsTo('App\Models\Kid');
    }
}