<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * App\Models\Route
 *
 * @property int $id
 * @property int $driver_id
 * @property string $name
 * @property string $created_at
 * @property string $updated_at
 * @property string $deleted_at
 * @property int $type
 * @property Driver $driver
 * @property RouteLog[] $routeLogs
 * @property RouteStop[] $routeStops
 * @property-read int|null $route_logs_count
 * @property-read int|null $route_stops_count
 * @method static bool|null forceDelete()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Route newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Route newQuery()
 * @method static \Illuminate\Database\Query\Builder|\App\Models\Route onlyTrashed()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Route query()
 * @method static bool|null restore()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Route whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Route whereDeletedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Route whereDriverId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Route whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Route whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Route whereType($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Route whereUpdatedAt($value)
 * @method static \Illuminate\Database\Query\Builder|\App\Models\Route withTrashed()
 * @method static \Illuminate\Database\Query\Builder|\App\Models\Route withoutTrashed()
 * @mixin \Eloquent
 */
class Route extends Model
{
    /**
     * The table associated with the model.
     * 
     * @var string
     */
    protected $table = 'route';
    
    use SoftDeletes;

    /**
     * @var array
     */
    protected $fillable = ['driver_id', 'name', 'created_at', 'updated_at', 'deleted_at', 'type'];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function driver()
    {
        return $this->belongsTo('App\Models\Driver');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function routeLogs()
    {
        return $this->hasMany('App\Models\RouteLog');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function routeStops()
    {
        return $this->hasMany('App\Models\RouteStop');
    }
}