<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * App\Models\Notification
 *
 * @property int $id
 * @property int $user_id
 * @property string $title
 * @property string $message
 * @property string $icon
 * @property string $created_at
 * @property string $updated_at
 * @property User $user
 * @property \Illuminate\Support\Carbon|null $deleted_at
 * @method static bool|null forceDelete()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Notification newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Notification newQuery()
 * @method static \Illuminate\Database\Query\Builder|\App\Models\Notification onlyTrashed()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Notification query()
 * @method static bool|null restore()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Notification whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Notification whereDeletedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Notification whereIcon($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Notification whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Notification whereMessage($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Notification whereTitle($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Notification whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Notification whereUserId($value)
 * @method static \Illuminate\Database\Query\Builder|\App\Models\Notification withTrashed()
 * @method static \Illuminate\Database\Query\Builder|\App\Models\Notification withoutTrashed()
 * @mixin \Eloquent
 */
class Notification extends Model
{

    /**
     * The table associated with the model.
     * 
     * @var string
     */
    protected $table = 'notification';
    
    use SoftDeletes;

    /**
     * @var array
     */
    protected $fillable = ['user_id', 'title', 'message', 'icon', 'created_at', 'updated_at'];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }

    public function getApiKey(){
        return env('app_id');
    }
}