<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * App\Models\FileType
 *
 * @property int $id
 * @property string $type
 * @property File[] $files
 * @property string $name
 * @property string|null $description
 * @property int|null $order
 * @property-read int|null $files_count
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\FileType newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\FileType newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\FileType query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\FileType whereDescription($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\FileType whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\FileType whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\FileType whereOrder($value)
 * @mixin \Eloquent
 */
class FileType extends Model
{
    /**
     * The table associated with the model.
     * 
     * @var string
     */
    protected $table = 'file_type';

    /**
     * @var array
     */
    protected $fillable = ['name', 'description', 'order'];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function files()
    {
        return $this->hasMany('App\Models\File');
    }
}