<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;


/**
 * App\Models\DriverSchool
 *
 * @property int $driver_id
 * @property int $school_id
 * @property Driver $driver
 * @property School $school
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\DriverSchool newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\DriverSchool newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\DriverSchool query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\DriverSchool whereDriverId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\DriverSchool whereSchoolId($value)
 * @mixin \Eloquent
 */
class DriverSchool extends Model
{
    /**
     * The table associated with the model.
     * 
     * @var string
     */
    protected $table = 'school_driver';
    public $timestamps = false;
    protected $primaryKey = null;
    public $incrementing = false;

    /**
     * @var array
     */
    protected $fillable = ['driver_id', 'school_id'];
    
    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function driver()
    {
        return $this->belongsTo('App\Models\Driver');
    }
    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function school()
    {
        return $this->belongsTo('App\Models\School');
    }
    
}