<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * App\Models\DriverLocation
 *
 * @property int $driver_id
 * @property int $location_id
 * @property Driver $driver
 * @property Location $location
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\DriverLocation newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\DriverLocation newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\DriverLocation query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\DriverLocation whereDriverId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\DriverLocation whereLocationId($value)
 * @mixin \Eloquent
 */
class DriverLocation extends Model
{
    /**
     * The table associated with the model.
     * 
     * @var string
     */
    protected $table = 'driver_location';
    public $timestamps = false;
    protected $primaryKey = null;
    public $incrementing = false;

    /**
     * @var array
     */
    protected $fillable = ['driver_id', 'location_id'];
    
    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function driver()
    {
        return $this->belongsTo('App\Models\Driver');
    }
    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function location()
    {
        return $this->belongsTo('App\Models\Location');
    }
    
}