<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * App\Models\Driver
 *
 * @property int $id
 * @property int $user_id
 * @property string $car_model
 * @property string $card_plate
 * @property string $validation
 * @property string $license_type
 * @property int $capacity
 * @property string $working_day
 * @property float $rating
 * @property string $created_at
 * @property string $updated_at
 * @property User $user
 * @property Kid[] $kids
 * @property School[] $schools
 * @property Route[] $routes
 * @property string|null $car_plate
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Kid[] $acceptedKids
 * @property-read int|null $accepted_kids_count
 * @property-read int|null $kids_count
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Location[] $locations
 * @property-read int|null $locations_count
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Kid[] $pendingKids
 * @property-read int|null $pending_kids_count
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\RouteLog[] $routeLogs
 * @property-read int|null $route_logs_count
 * @property-read int|null $routes_count
 * @property-read int|null $schools_count
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Driver newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Driver newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Driver query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Driver whereCapacity($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Driver whereCarModel($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Driver whereCarPlate($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Driver whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Driver whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Driver whereLicenseType($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Driver whereRating($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Driver whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Driver whereUserId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Driver whereValidation($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Driver whereWorkingDay($value)
 * @mixin \Eloquent
 */
class Driver extends Model
{
    /**
     * The table associated with the model.
     * 
     * @var string
     */
    protected $table = 'driver';

    /**
     * @var array
     */
    protected $fillable = ['user_id', 'car_model', 'car_plate', 'validation', 'license_type', 'capacity', 'working_day', 'rating', 'created_at', 'updated_at'];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
     
    public function acceptedKids()
    {
        return $this->belongsToMany('App\Models\Kid')->withPivot('status')->wherePivot('status', 1);
    }
    
    public function kids()
    {
        return $this->belongsToMany('App\Models\Kid')->withPivot('status');
    }
    
    public function pendingKids()
    {
        return $this->belongsToMany('App\Models\Kid')->withPivot('status')->wherePivot('status', 0);
    }

    public function locations()
    {
        return $this->belongsToMany('App\Models\Location');
    }

    public function schools()
    {
        return $this->belongsToMany('App\Models\School', 'school_driver');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function routes()
    {
        return $this->hasMany('App\Models\Route');
    }
    
    /**
     * @return \Illuminate\Database\Eloquent\Relations\hasManyThrough
     */
    public function routeLogs()
    {
        return $this->hasManyThrough('App\Models\RouteLog', 'App\Models\Route');
    }
}