<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class NewUser extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */

    private $first_name;
    private $user;
    private $pass;
    
    public function __construct($first_name, $user, $pass)
    {
        //
        $this->first_name = $first_name;
        $this->user = $user;
        $this->pass = $pass;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {

        return $this->subject($this->first_name.', ¡Bienvenido!')
            ->replyTo(env('MAIL_REPLYTO'), 'Staff BeeSafe')
            ->markdown('emails.user.newuser', [
                'url' => env('FRONTEND_URL'), 
                'first_name'=>$this->first_name,
                'user'=>$this->user,
                'pass'=>$this->pass
            ]);
       // return $this->subject('Nueva contraseña para BeeSafe')->markdown('emails.user.newuser');
    }
}
