<?php

namespace App\Api\V1\Controllers;

use Config;
use App\Models\User;
use App\Models\Driver;
use Auth;
use App\Http\Controllers\Controller;
use Dingo\Api\Routing\Helpers;
use App\Api\V1\Requests\SignUpRequest;
use Symfony\Component\HttpKernel\Exception\HttpException;

use App\Notifications\NewUser as NewUserNotification;
use Illuminate\Http\Request;

class SignUpController extends Controller
{
    use Helpers;
    
    public function signUp(Request $request)
    {
        
        $messages = [
            'email.required' => 'El campo email es obligatorio.',
            'email.email' => 'Por favor, ingrese una dirección de email válida.',
            'email.unique' => 'La dirección de email ya está en uso.',
            'unique' => 'La dirección de correo electrónico ya está en uso.',
        ];

        $validatedData = $request->validate([
            'first_name' => 'required|max:255',
            'last_name' => 'required|max:255',
            'email' => 'required|email',
            'password' => 'required|confirmed|min:6',
            'user_type_id' => 'required' 
        ], $messages);


        $usuarioAdmin = User::where('email', $validatedData['email'])->first();
        if($usuarioAdmin){
            return response()->json(['validacion_usuario' => 'El correo '.$validatedData['email'].' ya esta siendo utilizado '], 200);
        }
    


        $user = new User($validatedData);

        if(!$user->save()) {
            throw new HttpException(500);
        } else {
            if ($user->user_type_id === 1) {
                $driver = new Driver([
                    'user_id' => $user->id,
                    'car_plate' => $request->input('car_plate'),
                ]);
                if(!$driver->save()) {
                    throw new HttpException(500);
                }
                
                //Enviamos correo
                $user->notify(new NewUserNotification($validatedData['first_name'], $validatedData['email'], $validatedData['password']));
            }
        }

        $token = Auth::guard()->fromUser($user);
        return response()->json([
            'status' => 'ok',
            'token' => $token
        ], 201);
    }
} 