<?php

namespace App\Api\V1\Controllers;

use Symfony\Component\HttpKernel\Exception\HttpException;
use Tymon\JWTAuth\JWTAuth;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Notification;
use App\Models\User;
use App\Models\Kid;
use Tymon\JWTAuth\Exceptions\JWTException;
use Symfony\Component\HttpKernel\Exception\AccessDeniedHttpException;
use Auth;

use App\Traits\OneSignalMessages;

class NotificationController extends Controller
{
    use OneSignalMessages;
    
    public function index(Request $request, $id)
    {
        $notifications = Notification::where('user_id', $id)->orderBy('created_at', 'DESC')->get();
        
        return response()->json($notifications);
    }
    
    public function messageToDriver(Request $request, $id)
    {
        $message = $request->input('message');
        $sender = User::findOrFail($id);
        $kid = $request->input('kid');
        $driver = $request->input('driver');
        
        $this->sendNotificationFromParentToDriver($message, $kid, $driver, $sender);
        
        return response()->json(['status' => 'ok']);
    }
    
    public function messageToParents(Request $request, $id)
    {
        $message = $request->input('message');
        $sender = User::findOrFail($id);
        $kidId = $request->input('kid_id');
        $kid = Kid::with('users')->findOrFail($kidId);
        $parents = $kid->users->pluck('id');
        
        $this->sendNotificationFromDriverToParents($message, $kid, $parents, $sender);
        
        return response()->json(['status' => 'ok']);
    }
    
    public function delete(Request $request, $id)
    {
        $notification = Notification::findOrFail($id);
        $notification->delete();
        
        return response()->json($notification);
    }
    
} 