<?php

namespace App\Api\V1\Controllers;

use Symfony\Component\HttpKernel\Exception\HttpException;
use Tymon\JWTAuth\JWTAuth;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Kid;
use App\Models\Driver;
use App\Models\User;
use Tymon\JWTAuth\Exceptions\JWTException;
use Symfony\Component\HttpKernel\Exception\AccessDeniedHttpException;
use Illuminate\Database\Eloquent\Builder;
use Auth;

use Illuminate\Support\Facades\Log;


class KidController extends Controller
{

    public function show(Request $request, $id)
    {
        //Log::emergency('An informational message.'.$id);
        $kid = Kid::with('users', 'school', 'drivers')->findOrFail($id);

        return response()->json($kid);
    }

    public function create(Request $request)
    {
        $validatedData = $request->validate([
            'first_name' => 'required|max:255',
            'last_name' => 'required|max:255',
            'birth_date' => 'nullable',
            'gender' => 'nullable',
            'nationality' => 'nullable',
            'grade' => 'nullable',
            'school_id' => 'required',
            'medical_condition' => 'nullable',
            'address' => 'required',
            'status' => 'required',
        ]);
        $user_id = $request->input('user_id');
        $newKid = new Kid($validatedData);
        if(!$newKid->save()) {
            throw new HttpException(500);
        }
        if ($user_id !== null) {
            $newKid->users()->attach($user_id);
        }

        return response()->json($newKid);
    }

    public function removeFromList(Request $request)
    {
        $kid_id = $request->input('kid_id');
        $user_id = $request->input('user_id');
        $driver = Driver::where('user_id', $user_id)->first();
        $kid = Kid::with('users', 'drivers')->findOrFail($kid_id);
        $kid->drivers()->detach($driver->id);

        return response()->json($kid);
    }

    public function delete(Request $request, $id)
    {
        $kid = Kid::findOrFail($id);
        $kid->delete();

        return response()->json($kid);
    }

    public function update(Request $request, $kid_id)
    {
        $validatedData = $request->validate([
            'first_name' => 'required|max:255',
            'last_name' => 'required|max:255',
            'birth_date' => 'nullable',
            'gender' => 'nullable',
            'nationality' => 'nullable',
            'grade' => 'nullable',
            'identification' => 'nullable',
            'school_id' => 'required',
            'medical_condition' => 'nullable',
            'address' => 'nullable',
        ]);

        $updatedKid = Kid::findOrFail($kid_id);
        $updatedKid->first_name = $validatedData['first_name'];
        $updatedKid->last_name = $validatedData['last_name'];
        if ($validatedData['birth_date'] !== '') {
            $updatedKid->birth_date = $validatedData['birth_date'];
        } else {
            $updatedKid->birth_date = null;
        }
        if ($validatedData['gender'] !== '') {
            $updatedKid->gender = $validatedData['gender'];
        } else {
            $updatedKid->gender = null;
        }
        if ($validatedData['nationality'] !== '') {
            $updatedKid->nationality = $validatedData['nationality'];
        } else {
            $updatedKid->nationality = null;
        }
        if ($validatedData['grade'] !== '') {
            $updatedKid->grade = $validatedData['grade'];
        } else {
            $updatedKid->grade = null;
        }
        if ($validatedData['medical_condition'] !== '') {
            $updatedKid->medical_condition = $validatedData['medical_condition'];
        } else {
            $updatedKid->medical_condition = null;
        }
        if ($validatedData['address'] !== '') {
            $updatedKid->address = $validatedData['address'];
        } else {
            $updatedKid->address = null;
        }
        $updatedKid->identification = $validatedData['identification'];
        $updatedKid->school_id = $validatedData['school_id'];

        $updatedKid->update();

        return response()->json($updatedKid);
    }

    public function kidsForAssign(Request $request, $id)
    {
        $driverId = $request->input('driver_id');
        $driver = Driver::with('kids', 'schools')->findOrFail($driverId);

        $assignedKids = $driver->kids->pluck('id');
        $schools = $driver->schools()->pluck('id');

        $user = User::with(['kids' => function($kids) use ($assignedKids, $schools) {
            return $kids->whereNotIn('id', $assignedKids)->whereIn('school_id', $schools);
        }])
            ->where('id', $id)
            ->first();

        return response()->json($user);
    }

    public function kidsToAccept(Request $request, $id)
    {
        $driver = Driver::with('pendingKids')->where('user_id', $id)->first();
        $kidsToAccept = $driver->pendingKids;

        return response()->json($kidsToAccept);
    }

    public function checkKidStatus(Request $request, $id)
    {
        $kidStatus = Kid::select('status')->findOrFail($id);

        return response()->json($kidStatus);
    }

} 